<?php
// Script to add sort_order column to attachments table
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

try {
    // Check if sort_order column exists
    $stmt = $db->prepare("SHOW COLUMNS FROM attachments LIKE 'sort_order'");
    $stmt->execute();
    $columnExists = $stmt->fetch();
    
    if (!$columnExists) {
        // Add the sort_order column
        $db->exec("ALTER TABLE attachments ADD COLUMN sort_order INT NOT NULL DEFAULT 0");
        echo "Successfully added sort_order column to attachments table.\n";
        
        // Update existing attachments with default sort order
        $stmt = $db->query("SELECT id, post_id FROM attachments ORDER BY post_id, uploaded_at");
        $attachments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $current_post_id = null;
        $sort_order = 0;
        
        foreach ($attachments as $attachment) {
            // Reset sort order when we move to a new post
            if ($attachment['post_id'] != $current_post_id) {
                $current_post_id = $attachment['post_id'];
                $sort_order = 0;
            }
            
            // Update the sort order for this attachment
            $update_stmt = $db->prepare("UPDATE attachments SET sort_order = ? WHERE id = ?");
            $update_stmt->execute([$sort_order, $attachment['id']]);
            
            $sort_order++;
        }
        echo "Updated existing attachments with sequential sort orders.\n";
    } else {
        echo "sort_order column already exists in attachments table.\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "You may need to manually run this SQL command in your database:\n";
    echo "ALTER TABLE attachments ADD COLUMN sort_order INT NOT NULL DEFAULT 0;\n";
}